package gov.va.med.domain.service.messaging.encode.hl7;

import gov.va.med.domain.model.IPayload;
import gov.va.med.domain.model.PHRRequestPayload;
import gov.va.med.domain.service.messaging.DestinedRequest;
import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.MessagingException;
import gov.va.med.domain.service.messaging.encode.MessageEncoder;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7HeaderParameters;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7v24Helper;
import gov.va.med.domain.service.messaging.environment.EndPoint;

import java.util.Date;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.QPD;
import ca.uhn.hl7v2.model.v24.segment.RCP;

/**
 * HL7MessageEncoder
 *
 * @author Slava Uchitel
 * @version $Id: HL7MessageEncoder.java,v 1.5 2005/07/07 19:03:25 slava.uchitel Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public abstract class HL7MessageEncoder extends MessageEncoder 
{
     public final static String DEFAULT_FIELD_SEPARATOR = "|";
     public final static String DEFAULT_DELIMITERS = "^~\\&";
           
     public Object encode(IPayload payload, EndPoint ep) 
     	throws MessagingException            
     {
        return null;
     } 
     
	protected void fillMSHSegment(MSH msh, HL7HeaderParameters params) throws DataTypeException {
		HL7v24Helper.fillMSHSegment(msh, params);
	}

	protected void fillQPDSegment(QPD qpd, String requestId, Date fromDateLimit, Date toDateLimit, String patientIcn, String trigger, String subjectArea) throws DataTypeException, HL7Exception {
	
		qpd.getMessageQueryName().getIdentifier().setValue(trigger);
		qpd.getMessageQueryName().getText().setValue(subjectArea);
		qpd.getMessageQueryName().getNameOfCodingSystem().setValue("HL70471");
		qpd.getQueryTag().setValue(requestId);
		//set Request ID
		ST requestID = new ST();
		requestID.setValue(requestId);
		((Varies)qpd.getField(3, 0)).setData(requestID);
	
		//set SubjectArea ID
		ST subjectAreaID = new ST();
		subjectAreaID.setValue(subjectArea);
		((Varies)qpd.getField(4, 0)).setData(subjectAreaID);
	
		//set From Date
		ST fromDate = new ST();
		fromDate.setValue(dateToyyyyMMdd(fromDateLimit));
		((Varies)qpd.getField(5, 0)).setData(fromDate);
		//set To Date
		ST toDate = new ST();
		toDate.setValue(dateToyyyyMMdd(toDateLimit));
		((Varies)qpd.getField(6, 0)).setData(toDate);
		//Set ICN
		ST icn = new ST();
		icn.setValue(patientIcn);
		((Varies)qpd.getField(7, 0)).setData(icn);
		//Set DFN
		ST dfn = new ST();
		dfn.setValue(EMPTY_STRING);
		((Varies)qpd.getField(8, 0)).setData(dfn);
	}

	protected void fillPIDSegment(PID pid, String ssn, String icn, String dfn) throws HL7Exception {
		if(ssn != null && ssn.length() > 0)
			HL7v24Helper.addIdToPidPID(pid,
			                           ssn,
			                           HL7v24Helper.ID_SSN, MessagingConstants.EMPTY_STRING, MessagingConstants.EMPTY_STRING);
		if(icn != null && icn.length() > 0)
			HL7v24Helper.addIdToPidPID(pid,
			                           icn,
			                           HL7v24Helper.ID_ICN, MessagingConstants.EMPTY_STRING, MessagingConstants.EMPTY_STRING);
	}

	protected void fillRCPSegment(RCP rcp, int queryMode) throws DataTypeException {
		rcp.getQueryPriority().setValue((queryMode == QUERY_MODE_SYNCHRONOUS) ? "I" : "D");
	}
	
	protected HL7HeaderParameters buildHL7HeaderParameters(EndPoint endPoint, PHRRequestPayload payload) {
		HL7HeaderParameters params = new HL7HeaderParameters(endPoint);
		params.setMessageControlId(payload.getRequestId());
		return params;
	}
	
	protected HL7HeaderParameters buildHL7HeaderParameters(EndPoint endPoint, DestinedRequest request) {
	    HL7HeaderParameters params = new HL7HeaderParameters(endPoint);
		params.setMessageControlId(String.valueOf(request.getRequestId()));
		return params;
	}
}
